<?php
/**
 * Class alias for backward compatibility.
 *
 * @depecated These classes are deprecated since 3.6.0.
 * @package   SmartCrawl
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'smartcrawl_deprecated_class_autoload' ) ) {
	/**
	 * Add class alias for deprecated classes.
	 *
	 * @since 3.6.0
	 *
	 * @param string $old_class Old class name.
	 *
	 * @return void
	 */
	function smartcrawl_deprecated_class_autoload( $old_class ) {
		$class_mappings = array(
			'Smartcrawl_Loader'                            => '\SmartCrawl\SmartCrawl',
			'Smartcrawl_Init'                              => '\SmartCrawl\Init',
			'Smartcrawl_Base_Controller'                   => '\SmartCrawl\Controllers\Controller',
			'Smartcrawl_Checks'                            => '\SmartCrawl\Checks',
			'Smartcrawl_Compatibility'                     => '\SmartCrawl\Controllers\Compatibility',
			'Smartcrawl_Controller_Ajax_Search'            => '\SmartCrawl\Controllers\Ajax_Search',
			'Smartcrawl_Controller_Analysis'               => '\SmartCrawl\Controllers\Analysis',
			'Smartcrawl_Controller_Analysis_Content'       => '\SmartCrawl\Controllers\Analysis_Content',
			'Smartcrawl_Controller_Assets'                 => '\SmartCrawl\Controllers\Assets',
			'Smartcrawl_Controller_Cron'                   => '\SmartCrawl\Controllers\Cron',
			'Smartcrawl_Controller_Data'                   => '\SmartCrawl\Controllers\Data',
			'Smartcrawl_Controller_Hub_Abstract'           => '\SmartCrawl\Controllers\Hub_Abstract',
			'Smartcrawl_Controller_Hub'                    => '\SmartCrawl\Controllers\Hub',
			'Smartcrawl_Controller_Onboard'                => '\SmartCrawl\Controllers\Onboard',
			'Smartcrawl_Controller_Pointers'               => '\SmartCrawl\Controllers\Pointers',
			'Smartcrawl_Controller_Robots'                 => '\SmartCrawl\Modules\Advanced\Robots\Controller',
			'Smartcrawl_Controller_Welcome'                => '\SmartCrawl\Controllers\Welcome',
			'Smartcrawl_White_Label'                       => '\SmartCrawl\Controllers\White_Label',
			'Smartcrawl_Core_Request'                      => '\SmartCrawl\Core_Request',
			'Smartcrawl_Endpoint_Resolver'                 => '\SmartCrawl\Endpoint_Resolver',
			'Smartcrawl_Html'                              => '\SmartCrawl\Html',
			'Smartcrawl_Logger'                            => '\SmartCrawl\Logger',
			'Smartcrawl_Model'                             => '\SmartCrawl\Models\Model',
			'Smartcrawl_Model_Analysis'                    => '\SmartCrawl\Models\Analysis',
			'Smartcrawl_Model_Ignores'                     => '\SmartCrawl\Models\Ignores',
			'Smartcrawl_Model_User'                        => '\SmartCrawl\Models\User',
			'Smartcrawl_Renderable'                        => '\SmartCrawl\Renderable',
			'Smartcrawl_Simple_Renderer'                   => '\SmartCrawl\Simple_Renderer',
			'Smartcrawl_SeoReport'                         => '\SmartCrawl\Seo_Report',
			'Smartcrawl_Service'                           => '\SmartCrawl\Services\Service',
			'Smartcrawl_Settings'                          => '\SmartCrawl\Settings',
			'Smartcrawl_String_Utils'                      => '\SmartCrawl\String_Utils',
			'Smartcrawl_String'                            => '\SmartCrawl\SmartCrawl_String',
			'Smartcrawl_Syllable'                          => '\SmartCrawl\Syllable',
			'Smartcrawl_WorkUnit'                          => '\SmartCrawl\Work_Unit',
			'Smartcrawl_Youtube_Data_Fetcher'              => '\SmartCrawl\Youtube_Data_Fetcher',
			'Smartcrawl_Controller_Plugin_Links'           => '\SmartCrawl\Controllers\Plugin_Links',
			'Smartcrawl_Report_Permalinks_Controller'      => '\SmartCrawl\Controllers\Report_Permalinks',
			'Smartcrawl_Recommended_Plugins'               => '\SmartCrawl\Controllers\Recommended_Plugins',
			'Smartcrawl_Dashboard_Notices'                 => '\SmartCrawl\Controllers\Dash_Notices',
			'Smartcrawl_Lighthouse_Service'                => '\SmartCrawl\Services\Lighthouse',
			'Smartcrawl_Seo_Service'                       => '\SmartCrawl\Services\Seo',
			'Smartcrawl_Site_Service'                      => '\SmartCrawl\Services\Site',
			'Smartcrawl_Admin_Page'                        => '\SmartCrawl\Admin\Pages\Page',
			'Smartcrawl_Controller_Upgrade_Page'           => '\SmartCrawl\Admin\Pages\Upgrade',
			'Smartcrawl_Network_Settings_Page_Controller'  => '\SmartCrawl\Admin\Pages\Network_Settings',
			'Smartcrawl_Buddypress_Api'                    => '\SmartCrawl\BuddyPress\Api',
			'Smartcrawl_Cache_Manager'                     => '\SmartCrawl\Cache\Manager',
			'Smartcrawl_Post_Cache'                        => '\SmartCrawl\Cache\Post_Cache',
			'Smartcrawl_Term_Cache'                        => '\SmartCrawl\Cache\Term_Cache',
			'Smartcrawl_String_Cache'                      => '\SmartCrawl\Cache\String_Cache',
			'Smartcrawl_Object_Cache'                      => '\SmartCrawl\Cache\Object_Cache',
			'Smartcrawl_Check_Post_Abstract'               => '\SmartCrawl\Checks\Post_Check',
			'Smartcrawl_Check_Abstract'                    => '\SmartCrawl\Checks\Check',
			'Smartcrawl_Check_Content_Length'              => '\SmartCrawl\Checks\Content_Length',
			'Smartcrawl_Check_Focus'                       => '\SmartCrawl\Checks\Focus',
			'Smartcrawl_Check_Focus_Stopwords'             => '\SmartCrawl\Checks\Focus_Stopwords',
			'Smartcrawl_Check_Imgalts_Keywords'            => '\SmartCrawl\Checks\Imgalts_Keywords',
			'Smartcrawl_Check_Keyword_Density'             => '\SmartCrawl\Checks\Keyword_Density',
			'Smartcrawl_Check_Keywords_Used'               => '\SmartCrawl\Checks\Keywords_Used',
			'Smartcrawl_Check_Links_Count'                 => '\SmartCrawl\Checks\Links_Count',
			'Smartcrawl_Check_Metadesc_Keywords'           => '\SmartCrawl\Checks\Metadesc_Keywords',
			'Smartcrawl_Check_Metadesc_Handcraft'          => '\SmartCrawl\Checks\Metadesc_Handcraft',
			'Smartcrawl_Check_Metadesc_Length'             => '\SmartCrawl\Checks\Metadesc_Length',
			'Smartcrawl_Check_Para_Keywords'               => '\SmartCrawl\Checks\Para_Keywords',
			'Smartcrawl_Check_Slug_Keywords'               => '\SmartCrawl\Checks\Slug_Keywords',
			'Smartcrawl_Check_Slug_Underscores'            => '\SmartCrawl\Checks\Slug_Underscores',
			'Smartcrawl_Check_Subheadings_Keywords'        => '\SmartCrawl\Checks\Subheadings_Keywords',
			'Smartcrawl_Check_Title_Keywords'              => '\SmartCrawl\Checks\Title_Keywords',
			'Smartcrawl_Check_Title_Secondary_Keywords'    => '\SmartCrawl\Checks\Title_Secondary_Keywords',
			'Smartcrawl_Check_Title_Length'                => '\SmartCrawl\Checks\Title_Length',
			'Smartcrawl_Check_Bolded_Keyword'              => '\SmartCrawl\Checks\Bolded_Keyword',
			'Smartcrawl_Check_Nofollow_Links'              => '\SmartCrawl\Checks\Nofollow_Links',
			'Smartcrawl_Config_Collection'                 => '\SmartCrawl\Configs\Collection',
			'Smartcrawl_Configs_Service'                   => '\SmartCrawl\Configs\Service',
			'Smartcrawl_Controller_Configs'                => '\SmartCrawl\Configs\Controller',
			'Smartcrawl_Config_Model'                      => '\SmartCrawl\Configs\Model',
			'Smartcrawl_Export'                            => '\SmartCrawl\Configs\Export',
			'Smartcrawl_Import'                            => '\SmartCrawl\Configs\Import',
			'Smartcrawl_Model_IO'                          => '\SmartCrawl\Configs\Model_IO',
			'Smartcrawl_Controller_Crawler'                => '\SmartCrawl\Crawler\Controller',
			'Smartcrawl_Controller_Lighthouse'             => '\SmartCrawl\Lighthouse\Controller',
			'Smartcrawl_Lighthouse_Dashboard_Renderer'     => '\SmartCrawl\Lighthouse\Dashboard_Renderer',
			'Smartcrawl_Lighthouse_Group'                  => '\SmartCrawl\Lighthouse\Group',
			'Smartcrawl_Lighthouse_Options'                => '\SmartCrawl\Lighthouse\Options',
			'Smartcrawl_Lighthouse_Renderer'               => '\SmartCrawl\Lighthouse\Renderer',
			'Smartcrawl_Lighthouse_Report'                 => '\SmartCrawl\Lighthouse\Report',
			'Smartcrawl_404_Page'                          => '\SmartCrawl\Entities\Page_404',
			'Smartcrawl_Blog_Home'                         => '\SmartCrawl\Entities\Blog_Home',
			'Smartcrawl_Buddypress_Group'                  => '\SmartCrawl\Entities\BuddyPress_Group',
			'Smartcrawl_Buddypress_Profile'                => '\SmartCrawl\Entities\BuddyPress_Profile',
			'Smartcrawl_Date_Archive'                      => '\SmartCrawl\Entities\Date_Archive',
			'Smartcrawl_Entity'                            => '\SmartCrawl\Entities\Entity',
			'Smartcrawl_Entity_With_Archive'               => '\SmartCrawl\Entities\Entity_With_Archive',
			'Smartcrawl_Post'                              => '\SmartCrawl\Entities\Post',
			'Smartcrawl_Post_Author'                       => '\SmartCrawl\Entities\Post_Author',
			'Smartcrawl_Post_Type'                         => '\SmartCrawl\Entities\Post_Type',
			'Smartcrawl_Product'                           => '\SmartCrawl\Entities\Product',
			'Smartcrawl_Search_Page'                       => '\SmartCrawl\Entities\Search_Page',
			'Smartcrawl_Static_Home'                       => '\SmartCrawl\Entities\Static_Home',
			'Smartcrawl_Taxonomy_Term'                     => '\SmartCrawl\Entities\Taxonomy_Term',
			'Smartcrawl_Woo_Shop_Page'                     => '\SmartCrawl\Entities\Woo_Shop_Page',
			'Smartcrawl_Subsite_Process_Runner'            => '\SmartCrawl\Multisite\Subsite_Process_Runner',
			'Smartcrawl_Network_Configs_Controller'        => '\SmartCrawl\Multisite\Network_Configs',
			'Smartcrawl_Sitewide_Deprecation_Controller'   => '\SmartCrawl\Multisite\Sitewide_Deprecation',
			'Smartcrawl_Readability_Formula'               => '\SmartCrawl\Readability\Formulas\Formula',
			'Smartcrawl_Readability_Formula_Flesch'        => '\SmartCrawl\Readability\Formulas\Flesch',
			'Smartcrawl_Controller_Readability'            => '\SmartCrawl\Readability\Controller',
			'Smartcrawl_Controller_Redirection'            => '\SmartCrawl\Modules\Advanced\Redirects\Controller',
			'Smartcrawl_Model_Redirection'                 => '\SmartCrawl\Modules\Advanced\Redirects\Model',
			'Smartcrawl_Redirect_Item'                     => '\SmartCrawl\Modules\Advanced\Redirects\Item',
			'Smartcrawl_Redirect_Utils'                    => '\SmartCrawl\Modules\Advanced\Redirects\Utils',
			'Smartcrawl_Redirects_Database_Table'          => '\SmartCrawl\Modules\Advanced\Redirects\Database_Table',
			'Smartcrawl_Lighthouse_Canonical_Check'        => '\SmartCrawl\Lighthouse\Checks\Canonical',
			'Smartcrawl_Lighthouse_Check'                  => '\SmartCrawl\Lighthouse\Checks\Check',
			'Smartcrawl_Lighthouse_Document_Title_Check'   => '\SmartCrawl\Lighthouse\Checks\Document_Title',
			'Smartcrawl_Lighthouse_Font_Size_Check'        => '\SmartCrawl\Lighthouse\Checks\Font_Size',
			'Smartcrawl_Lighthouse_Hreflang_Check'         => '\SmartCrawl\Lighthouse\Checks\Hreflang',
			'Smartcrawl_Lighthouse_Http_Status_Code_Check' => '\SmartCrawl\Lighthouse\Checks\Http_Status_Code',
			'Smartcrawl_Lighthouse_Image_Alt_Check'        => '\SmartCrawl\Lighthouse\Checks\Image_Alt',
			'Smartcrawl_Lighthouse_Is_Crawlable_Check'     => '\SmartCrawl\Lighthouse\Checks\Is_Crawlable',
			'Smartcrawl_Lighthouse_Link_Text_Check'        => '\SmartCrawl\Lighthouse\Checks\Link_Text',
			'Smartcrawl_Lighthouse_Meta_Description_Check' => '\SmartCrawl\Lighthouse\Checks\Meta_Description',
			'Smartcrawl_Lighthouse_Plugins_Check'          => '\SmartCrawl\Lighthouse\Checks\Plugins',
			'Smartcrawl_Lighthouse_Robots_Txt_Check'       => '\SmartCrawl\Lighthouse\Checks\Robots_Txt',
			'Smartcrawl_Lighthouse_Structured_Data_Check'  => '\SmartCrawl\Lighthouse\Checks\Structured_Data',
			'Smartcrawl_Lighthouse_Tap_Targets_Check'      => '\SmartCrawl\Lighthouse\Checks\Tap_Targets',
			'Smartcrawl_Lighthouse_Viewport_Check'         => '\SmartCrawl\Lighthouse\Checks\Viewport',
			'Smartcrawl_Lighthouse_Table'                  => '\SmartCrawl\Lighthouse\Tables\Table',
			'Smartcrawl_Lighthouse_Tap_Targets_Table'      => '\SmartCrawl\Lighthouse\Tables\Tap_Targets',
			'Smartcrawl_Schema_Fragment'                   => '\SmartCrawl\Schema\Fragments\Fragment',
			'Smartcrawl_Schema_Fragment_Archive'           => '\SmartCrawl\Schema\Fragments\Archive',
			'Smartcrawl_Schema_Fragment_Article'           => '\SmartCrawl\Schema\Fragments\Article',
			'Smartcrawl_Schema_Fragment_Author_Archive'    => '\SmartCrawl\Schema\Fragments\Author_Archive',
			'Smartcrawl_Schema_Fragment_Blog_Home'         => '\SmartCrawl\Schema\Fragments\Blog_Home',
			'Smartcrawl_Schema_Fragment_Blog_Home_Webpage' => '\SmartCrawl\Schema\Fragments\Blog_Home_Webpage',
			'Smartcrawl_Schema_Fragment_Comments'          => '\SmartCrawl\Schema\Fragments\Comments',
			'Smartcrawl_Schema_Fragment_Date_Archive'      => '\SmartCrawl\Schema\Fragments\Date_Archive',
			'Smartcrawl_Schema_Fragment_Footer'            => '\SmartCrawl\Schema\Fragments\Footer',
			'Smartcrawl_Schema_Fragment_Header'            => '\SmartCrawl\Schema\Fragments\Header',
			'Smartcrawl_Schema_Fragment_Media'             => '\SmartCrawl\Schema\Fragments\Media',
			'Smartcrawl_Schema_Fragment_Menu'              => '\SmartCrawl\Schema\Fragments\Menu',
			'Smartcrawl_Schema_Fragment_Minimal_Webpage'   => '\SmartCrawl\Schema\Fragments\Minimal_Webpage',
			'Smartcrawl_Schema_Fragment_Post'              => '\SmartCrawl\Schema\Fragments\Post',
			'Smartcrawl_Schema_Fragment_Post_Author'       => '\SmartCrawl\Schema\Fragments\Post_Author',
			'Smartcrawl_Schema_Fragment_PT_Archive'        => '\SmartCrawl\Schema\Fragments\Post_Type_Archive',
			'Smartcrawl_Schema_Fragment_Publisher'         => '\SmartCrawl\Schema\Fragments\Publisher',
			'Smartcrawl_Schema_Fragment_Publishing_Person' => '\SmartCrawl\Schema\Fragments\Publishing_Person',
			'Smartcrawl_Schema_Fragment_Search'            => '\SmartCrawl\Schema\Fragments\Search',
			'Smartcrawl_Schema_Fragment_Singular'          => '\SmartCrawl\Schema\Fragments\Singular',
			'Smartcrawl_Schema_Fragment_Static_Home'       => '\SmartCrawl\Schema\Fragments\Static_Home',
			'Smartcrawl_Schema_Fragment_Tax_Archive'       => '\SmartCrawl\Schema\Fragments\Tax_Archive',
			'Smartcrawl_Schema_Fragment_Webpage'           => '\SmartCrawl\Schema\Fragments\Webpage',
			'Smartcrawl_Schema_Fragment_Website'           => '\SmartCrawl\Schema\Fragments\Website',
			'Smartcrawl_Schema_Fragment_Woo_Shop'          => '\SmartCrawl\Schema\Fragments\Woo_Shop',
			'Smartcrawl_Schema_Fragment_Breadcrumb'        => '\SmartCrawl\Schema\Fragments\Breadcrumb',
			'Smartcrawl_Schema_Loop'                       => '\SmartCrawl\Schema\Loops\Loop',
			'Smartcrawl_Schema_Loop_Comments'              => '\SmartCrawl\Schema\Loops\Comments',
			'Smartcrawl_Schema_Loop_Woocommerce_Reviews'   => '\SmartCrawl\Schema\Loops\Woocommerce_Reviews',
			'Smartcrawl_Schema_Property_Source'            => '\SmartCrawl\Schema\Sources\Property',
			'Smartcrawl_Schema_Source_Author'              => '\SmartCrawl\Schema\Sources\Author',
			'Smartcrawl_Schema_Source_Comment'             => '\SmartCrawl\Schema\Sources\Comment',
			'Smartcrawl_Schema_Source_Comment_Factory'     => '\SmartCrawl\Schema\Sources\Comment_Factory',
			'Smartcrawl_Schema_Source_Factory'             => '\SmartCrawl\Schema\Sources\Factory',
			'Smartcrawl_Schema_Source_Media'               => '\SmartCrawl\Schema\Sources\Media',
			'Smartcrawl_Schema_Source_Options'             => '\SmartCrawl\Schema\Sources\Options',
			'Smartcrawl_Schema_Source_Post'                => '\SmartCrawl\Schema\Sources\Post',
			'Smartcrawl_Schema_Source_Post_Meta'           => '\SmartCrawl\Schema\Sources\Post_Meta',
			'Smartcrawl_Schema_Source_Schema_Settings'     => '\SmartCrawl\Schema\Sources\Schema_Settings',
			'Smartcrawl_Schema_Source_SEO_Meta'            => '\SmartCrawl\Schema\Sources\SEO_Meta',
			'Smartcrawl_Schema_Source_Site_Settings'       => '\SmartCrawl\Schema\Sources\Site_Settings',
			'Smartcrawl_Schema_Source_Text'                => '\SmartCrawl\Schema\Sources\Text',
			'Smartcrawl_Schema_Source_Woocommerce'         => '\SmartCrawl\Schema\Sources\Woocommerce',
			'Smartcrawl_Schema_Source_Woocommerce_Review'  => '\SmartCrawl\Schema\Sources\Woocommerce_Review',
			'Smartcrawl_Schema_Type'                       => '\SmartCrawl\Schema\Types\Type',
			'Smartcrawl_Schema_Type_Woo_Product'           => '\SmartCrawl\Schema\Types\Woo_Product',
			'Smartcrawl_Controller_Media_Schema_Data'      => '\SmartCrawl\Schema\Media',
			'Smartcrawl_Controller_Schema_Types'           => '\SmartCrawl\Schema\Types',
			'Smartcrawl_Schema_Printer'                    => '\SmartCrawl\Schema\Printer',
			'Smartcrawl_Schema_Property_Values'            => '\SmartCrawl\Schema\Property_Values',
			'Smartcrawl_Schema_Type_Conditions'            => '\SmartCrawl\Schema\Type_Conditions',
			'Smartcrawl_Schema_Type_Constants'             => '\SmartCrawl\Schema\Type_Constants',
			'Smartcrawl_Schema_Utils'                      => '\SmartCrawl\Schema\Utils',
			'Smartcrawl_Sitemap_BP_Groups_Query'           => '\SmartCrawl\Sitemaps\General\Queries\BP_Groups',
			'Smartcrawl_Sitemap_BP_Profile_Query'          => '\SmartCrawl\Sitemaps\General\Queries\BP_Profile',
			'Smartcrawl_Sitemap_Extras_Query'              => '\SmartCrawl\Sitemaps\General\Queries\Extras',
			'Smartcrawl_Sitemap_Posts_Query'               => '\SmartCrawl\Sitemaps\General\Queries\Posts',
			'Smartcrawl_Sitemap_Terms_Query'               => '\SmartCrawl\Sitemaps\General\Queries\Terms',
			'Smartcrawl_General_Sitemap'                   => '\SmartCrawl\Sitemaps\General\Sitemap',
			'Smartcrawl_Sitemap_Item'                      => '\SmartCrawl\Sitemaps\General\Item',
			'Smartcrawl_News_Sitemap'                      => '\SmartCrawl\Sitemaps\News\Sitemap',
			'Smartcrawl_News_Sitemap_Data'                 => '\SmartCrawl\Sitemaps\News\Data',
			'Smartcrawl_Sitemap_News_Item'                 => '\SmartCrawl\Sitemaps\News\Item',
			'Smartcrawl_Sitemap_News_Query'                => '\SmartCrawl\Sitemaps\News\Query',
			'Smartcrawl_Controller_Sitemap'                => '\SmartCrawl\Sitemaps\Controller',
			'Smartcrawl_Controller_Sitemap_Front'          => '\SmartCrawl\Sitemaps\Front',
			'Smartcrawl_Controller_Sitemap_Native'         => '\SmartCrawl\Sitemaps\Native',
			'Smartcrawl_Sitemap'                           => '\SmartCrawl\Sitemaps\Sitemap',
			'Smartcrawl_Sitemap_Cache'                     => '\SmartCrawl\Sitemaps\Cache',
			'Smartcrawl_Sitemap_Index_Item'                => '\SmartCrawl\Sitemaps\Index_Item',
			'Smartcrawl_Sitemap_Post_Fetcher'              => '\SmartCrawl\Sitemaps\Post_Fetcher',
			'Smartcrawl_Sitemap_Query'                     => '\SmartCrawl\Sitemaps\Query',
			'Smartcrawl_Sitemap_Utils'                     => '\SmartCrawl\Sitemaps\Utils',
			'Smartcrawl_Sitemaps_Provider'                 => '\SmartCrawl\Sitemaps\Provider',
			'Smartcrawl_Controller_Third_Party_Import'     => '\SmartCrawl\Third_Party_Import\Controller',
			'Smartcrawl_Importer'                          => '\SmartCrawl\Third_Party_Import\Importer',
			'Smartcrawl_AIOSEOP_Importer'                  => '\SmartCrawl\Third_Party_Import\AIOSEOP',
			'Smartcrawl_Yoast_Importer'                    => '\SmartCrawl\Third_Party_Import\Yoast',
			'Smartcrawl_Controller_Woo_Global_Id'          => '\SmartCrawl\Modules\Advanced\WooCommerce\Global_Id',
			'Smartcrawl_Controller_Woocommerce'            => '\SmartCrawl\Modules\Advanced\WooCommerce\Controller',
			'Smartcrawl_Woocommerce_Data'                  => '\SmartCrawl\Integration\Woocommerce\Data',
			'Smartcrawl_Woocommerce_Api'                   => '\SmartCrawl\Integration\Woocommerce\Api',
			'Smartcrawl_Controller_Wpml'                   => '\SmartCrawl\WPML\Controller',
			'Smartcrawl_Wpml_Api'                          => '\SmartCrawl\WPML\Api',
			'Smartcrawl_Admin'                             => '\SmartCrawl\Admin\Admin',
			'Smartcrawl_Metabox'                           => '\SmartCrawl\Admin\Metabox',
			'Smartcrawl_Settings_Admin'                    => '\SmartCrawl\Admin\Settings\Admin_Settings',
			'Smartcrawl_Taxonomy'                          => '\SmartCrawl\Admin\Taxonomy',
			'Smartcrawl_Autolinks_UI'                      => '\SmartCrawl\Admin\UI\Advanced',
			'Smartcrawl_OnPage_UI'                         => '\SmartCrawl\Admin\UI\Onpage',
			'Smartcrawl_SEO_Analysis_UI'                   => '\SmartCrawl\Admin\UI\SEO_Analysis',
			'Smartcrawl_Readability_Analysis_UI'           => '\SmartCrawl\Admin\UI\Readability_Analysis',
			'Smartcrawl_Social_UI'                         => '\SmartCrawl\Admin\UI\Social',
			'Smartcrawl_Autolinks_Settings'                => '\SmartCrawl\Admin\Settings\Advanced',
			'Smartcrawl_Settings_Dashboard'                => '\SmartCrawl\Admin\Settings\Dashboard',
			'Smartcrawl_Health_Settings'                   => '\SmartCrawl\Admin\Settings\Health',
			'Smartcrawl_Onpage_Settings'                   => '\SmartCrawl\Admin\Settings\Onpage',
			'Smartcrawl_Schema_Settings'                   => '\SmartCrawl\Admin\Settings\Schema',
			'Smartcrawl_Settings_Settings'                 => '\SmartCrawl\Admin\Settings\Settings',
			'Smartcrawl_Sitemap_Settings'                  => '\SmartCrawl\Admin\Settings\Sitemap',
			'Smartcrawl_Social_Settings'                   => '\SmartCrawl\Admin\Settings\Social',
			'Smartcrawl_Autolinks'                         => '\SmartCrawl\Modules\Advanced\Autolinks\Controller',
			'Smartcrawl_OpenGraph_Printer'                 => '\SmartCrawl\Social\OpenGraph_Printer',
			'Smartcrawl_Pinterest_Printer'                 => '\SmartCrawl\Social\Pinterest_Printer',
			'Smartcrawl_Social_Front'                      => '\SmartCrawl\Social\Controller',
			'Smartcrawl_Twitter_Printer'                   => '\SmartCrawl\Social\Twitter_Printer',
			'Smartcrawl_OnPage'                            => '\SmartCrawl\Controllers\OnPage',
			'Smartcrawl_Sitemaps_Dashboard_Widget'         => '\SmartCrawl\Sitemaps\Dashboard_Widget',
			'Smartcrawl_Xml_VideoSitemap'                  => '\SmartCrawl\Sitemaps\Video\Sitemap',
			'Smartcrawl_Controller_Moz_Cron'               => '\SmartCrawl\Modules\Advanced\Seomoz\Cron',
			'Smartcrawl_Moz_API'                           => '\SmartCrawl\Modules\Advanced\Seomoz\API',
			'Smartcrawl_Front'                             => '\SmartCrawl\Front',
			'Smartcrawl_Controller_Breadcrumbs'            => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Controller',
			'Smartcrawl_Breadcrumb_Base'                   => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Builder',
			'Smartcrawl_Pages_Breadcrumb'                  => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Pages',
			'Smartcrawl_Posts_Breadcrumb'                  => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Posts',
			'Smartcrawl_404_Breadcrumb'                    => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Error_404',
			'Smartcrawl_Search_Breadcrumb'                 => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Search',
			'Smartcrawl_Taxonomies_Breadcrumb'             => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Taxonomies',
			'Smartcrawl_Archives_Breadcrumb'               => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Archives',
			'Smartcrawl_Woocommerce_Breadcrumb'            => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\Woocommerce',
			'Smartcrawl_No_Breadcrumb'                     => '\SmartCrawl\Modules\Advanced\Breadcrumbs\Builders\No',
			'Smartcrawl_Controller_Primary_Terms'          => '\SmartCrawl\Controllers\Primary_Terms',
			// PHPCS fix.
			'Smartcrawl_Lighthouse_Crawlable_Anchors_Check' => '\SmartCrawl\Lighthouse\Checks\Crawlable_Anchors',
			'Smartcrawl_Controller_Sitemap_Troubleshooting' => '\SmartCrawl\Sitemaps\Troubleshooting',
			'Smartcrawl_Schema_Source_Woocommerce_Review_Factory' => '\SmartCrawl\Schema\Sources\Woocommerce_Review_Factory',
		);

		if ( ! isset( $class_mappings[ $old_class ] ) ) {
			return;
		}

		$new_class = $class_mappings[ $old_class ];

		/**
		 * Filters whether to trigger an error for deprecated functions.
		 *
		 * @since 3.6.0
		 *
		 * @param bool $trigger Whether to trigger the error for deprecated functions. Default true.
		 */
		if ( WP_DEBUG && apply_filters( 'smartcrawl_deprecated_class_trigger_error', true ) ) {
			trigger_error( // phpcs:ignore
				sprintf(
				/* translators: 1: Old class name, 2: Version number, 3: New class name. */
					esc_html__( 'Class %1$s is deprecated since version %2$s! Use %3$s instead.', 'wds' ),
					esc_attr( $old_class ),
					'3.6.0',
					esc_attr( $new_class )
				),
				E_USER_DEPRECATED
			);
		}

		// Add class alias.
		class_alias( $new_class, $old_class );
	}
}

spl_autoload_register( 'smartcrawl_deprecated_class_autoload' );